#define F_CPU 4000000 				//czestotliwo pracy zegara
#define CYCLES_PER_US ((F_CPU+500000)/1000000)	//tikw na sekunde

#define LED		PORTB 	  			//takie tam
#define LED_D		DDRB

#define CTRL	PORTC
#define CTRL_D	DDRC

#define IN			IN_I
#define IN_P		PORTD
#define IN_I		PIND
#define IN_D		DDRD

#define TIM 65535-10000 			// autoadowanie do timera

#include <avr/io.h>						// obsuga we/wy
#include <util/delay.h> 			// obsuga opnie
#include <avr/interrupt.h>  	// obsuga przerwa

unsigned int t, meas, pulse, pulse1, pulse2, pulse3;

SIGNAL (SIG_INTERRUPT0) 			// przerwanie od INT0 (wejcie na 4 pinie)
{
	unsigned int temp, off;			// off - max dopuszczalna zmiana pomiaru

	off = 20;

	TCNT1 = TIM;								// aduj do timera warto pocztkow
	CTRL |= _BV(4);							// zapal diod pomiarow
	temp = (70 * 80) / t;				// przelicz na impulsy / minute
	
	if (meas == 0) {						// ignoruj pierwszy pomiar
		meas = 1;									
	}
	else{												// pomiary >1

		if ( (temp - pulse < off || pulse - temp < off) && pulse3 != 0 ){	
			// jeeli pomiar nierni si o wicej ni 20 od redniej
			// i pulse3 zawiera pomiar (zostay wykonane 3 pocztkowe pomiary)

			pulse3 = pulse2;				// przechowuje poprzednie pomiary
			pulse2 = pulse1;				// j.w.
			pulse1 = temp;					// zapisuje biecy pomiar

			pulse = (pulse1 + pulse2 + pulse3 ) / 3; // rednia z ostatnich 3ch
		}
		else {
			if (pulse3 == 0) { 			// jeeli nie pobra 3ch pierwszych pomiarw
				pulse3 = pulse2;
				pulse2 = pulse1;
				pulse1 = temp;

				pulse = (pulse1 + pulse2 + pulse3 ) / 3;
			}
		}
	}

	t = 0;											// zeruj liczb przepenie timera
	_delay_loop_2(2000);				// czekaj iletam ;]
}


SIGNAL (SIG_OVERFLOW1)        // przerwanie od przepenienia
{
	TCNT1 = TIM;								// wpisz do timera wart poczatkowa
  t++;												// zwieksz t - liczba przepenien timera
}

// funkcja dekodujca DEC -> LED
unsigned int decode(unsigned int num) {

	if (num == 0)
	return _BV(1) + _BV(2) + _BV(3) + _BV(4) + _BV(5) + _BV(6);
	// np - jeeli jest 0, zapal bity 1,2,3,4,5,6

	if (num == 1)
	return _BV(3) + _BV(4);

	if (num == 2)
	return _BV(2) + _BV(3) + _BV(0) + _BV(6) + _BV(5);

	if (num == 3)
	return _BV(2) + _BV(3) + _BV(0) + _BV(4) + _BV(5);

	if (num == 4)
	return _BV(1) + _BV(0) + _BV(3) + _BV(4);
	
	if (num == 5)
	return _BV(2) + _BV(1) + _BV(0) + _BV(4) + _BV(5);
	
	if (num == 6)
	return _BV(2) + _BV(1) + _BV(6) + _BV(5) + _BV(4) + _BV(0);
	
	if (num == 7)
	return _BV(2) + _BV(3) + _BV(4);
	
	if (num == 8)
	return _BV(0) + _BV(1) + _BV(2) + _BV(3) + _BV(4) + _BV(5) + _BV(6);
	
	if (num == 9)
	return _BV(0) + _BV(1) + _BV(2) + _BV(3) + _BV(4) + _BV(5);

	return 0;

}

// wywietl na LED
void disp( unsigned int num ) {

	unsigned int delay = 1500;	// opoznienie

	_delay_loop_2(delay);				// opoznienie
	CTRL |= _BV(0);							// przecz na LED - jednoci
	LED = decode(num % 10);			// oblicz 1 cyfr, dekoduj i wyslij na port
	CTRL &= _BV(0);							// "opu" LED - jednoci

	_delay_loop_2(delay);
	CTRL |= _BV(1);							// przecz na LED - dziesiatki
	LED = decode(((num - (num % 10)) % 100) / 10);	// oblicz 2 cyfr, dekoduj i wyslij na port
	CTRL &= _BV(1);							// ...

	if (num / 100 != 0) {				// jeeli s jakie setki
		_delay_loop_2(delay);			// delay
		CTRL |= _BV(2);						// przecz na LED - setki
		LED = decode(num / 100);	// oblicz 3 cyfr, dekoduj i wyslij na port
		CTRL &= _BV(2);						// ...
	}
	
}

int main( void )              // program gwny
{
	t=0;												// zlicza ilosc przepelnien timera
	pulse = 0;									// przechowuje wartosc pulsu

  CTRL_D = LED_D= 0xff;				// usawia porty jako wyjscie
  IN_D = 0;										//	j.w. tylko wejcie

	IN_P = 0xff;								// podnosi wejcia do 1
  LED = 0;										// zeruje wyjcie na LED

	TIMSK = _BV(TOIE1);					// wcza przerwanie od INT0 (pin 4)
	TCNT1 = TIM;								// aduje warto pocztkow do timera
  TCCR1A = 0x00;							// czasomierz bez dodatkw
  TCCR1B = _BV(CS00);					// taktowany F_CPU

  GIMSK = _BV(INT0);					// wcz obsug przerwa
  MCUCR = _BV(ISC01);					// INT0 reaguje na zbocze opadajce

	sei();											// wcza obsug przerwa


  while(1)                    // ptla nieskoczona (programu)
  {

		if (t > 150) {
				// jeeli nie ma pomiaru przez duszy czas zeruj zmienne
				meas = pulse = pulse1 = pulse2 = pulse3 = 0;
		}

		if (pulse < 60 && pulse != 0) {
			// jeeli puls ponizej 60 - bradykardia - zapal diod
			CTRL |= _BV(3);
		}

		if (pulse > 100) {
			// jeeli puls powyej 100 - tachykardia - zapal inn diod
			CTRL |= _BV(5);
		}

		disp(pulse);							// wywietl ttno

  }
}
//KONIEC
