%% Rekurencyjna Metoda Najmniejszych Kwadratów (RMNK)
% [a, an, an_tab] = rmnk(N, S)
%
% N - liczba przykladow
% S - ilosc wejsc obiektu (dlugosc przykladu)


function [an, an_tab] = rmnk(a, x, z, N, S)

%% inicjalizacja


    an = zeros(S,1);    %wektor kolumnowy zawierajacy estymaty nieznanych parametrow obiektu
    an_tab = zeros(N,S);
    
    % wartosc poczatkowa tablicy P
    P = eye(S) * 10^6;

%% pętla programowa algorytmu

    for i = 1:N;
        
        %x(i,:) - xk'
        
        kappa = 1 / (1 + x(i,:) * P * x(i,:)');     % rownanie (1)
        P = P - kappa * P * x(i,:)' * x(i,:) * P;   % rownanie (2)
        
        yn = x(i,:) * a + z(i);                     % wyznacz odpowidź obiektu na pobudzenie
    
        
        delta = P * x(i,:)' * ( yn - x(i,:)*an );   % oblicz poprawkę
        an = an + delta;                            % popraw wynik
    
        an_tab(i,:) = ((a - an)./a) * 100;          % zapisz rezultat

    end
end