%Badanie UAR w stanach przejciowych
clf;

k = 2;
T = 4;
Ko = tf(k, [T^3 3*T^2 3*T 1]);

P_kp = 3;
P_r  = series(tf(P_kp,1),   Ko);
P_f  = feedback(1, P_r);

PI_kp = 2.7;
PI_Ti = 13.33;
PI_I  = tf(1, [PI_Ti 0]);
PI    = parallel(1,  PI_I);
PI_s  = series(PI_kp,  PI);
PI_r  = series(PI_s,  Ko);
PI_f  = feedback(1, PI_r);

PID_kp = 3.6;
PID_Ti = 8;
PID_Td = 2;
PID_I  = tf(1, [PID_Ti 0]);
PID_D  = tf([PID_Td 0],1);
PID    = parallel(1,  PID_I);
PID    = parallel(PID, PID_D);
PID_s  = series(PID_kp, PID);
PID_r  = series(PID_s, Ko);
PID_f  = feedback(1, PID_r);

hold on;
 step(P_f^2);
 step(PI_f^2);
 step(PID_f^2);
 legend('P','PI','PID');
hold off;

grid on;