function [cm] = mom3(X,tau1,tau2)
% MOM3 oblicza laczny moment 3-go rzedu
%	[cm] = MOM3(X,tau1,tau2)
%
% Oblicza laczny moment 3-go rzedu procesu stacjonarnego 
% (rowny kumulantowi 3-go rzedu dla procesow o wartosci
% oczekiwanej rownej 0). Wynik podaje dla pierwszej cwiartki
% plaszczyzny tau1-tau2.
%
% Wejscie
%	X		- analizowany proces stacjonarny
%	tau1	- przesuniecie1
%	tau2	- przesuniecie2
%
% Wyjscie
%	cm		- laczny moment 3-go rzedu
%

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 
[m,n]=size(X);
if (n>m)
	X=X.';
endif
len=max(m,n);
tau1=min(len,tau1);
tau2=min(len,tau2);

cm=zeros(tau1,tau2);

for l=(1:tau2)
	for k=(1:tau1)
		dl_dan=len-max(l,k)+1;
		cm(k,l)=sum(X(1:dl_dan).*X(k:k+dl_dan-1).*X(l:l+dl_dan-1))/len;
	endfor
endfor

endfunction