%BAZA2 wizualizacja funkcji bazowych
% 	   kazda probka (zespolona) funkcji bazowych reprezentowana jest przez wektor na plaszczyznie zespolonej
%	   (os Im - pionowo, os Re - pozomo)
%
%		Uwaga: zanotowano problemy z dzialaniem funkcji quiver pod linuxem w Octave 2.1.6

% parametry
N = 8;				% ilosc punktow transformaty (=dlugosc sygnalu)
fs = 8000;			% czestotliwosc probkowanie
mnoznik = 5;		% zageszczenie probek dla reprezentacji ,,ciaglej''
SKAL = 0.4;			% wspolczynnik skalujacy amplitudy

n = 1:N;				% indeksy prbek
nContSize = mnoznik*N;	% dlugosc wektora z indeksami reprezentacji ,,ciaglych''
nCont = linspace(1,N,nContSize);	% indeksy dla ,,ciaglych'' wersji sygnalow

% inicjalizacja macierzy z wektorami przestrzeni bazowej
mSize = N;
B 	= zeros(mSize, N);
BCont 	= zeros(mSize, nContSize);

% ---------------- Obliczanie bazy
m = 1:N;
B(m,n) = exp(-i*2*pi*(m-1)'*(n-1)/N);

[NN MM] = meshgrid(n, m);
clf;clg;
quiver (NN, MM, SKAL* real(B), SKAL* imag(B));
title("zespolone wspolrzedne wektorow bazowych");
xlabel ("n - numery probek");
ylabel ("m")