%PRZECIEK pozwala eksperymentowac z probkowaniem widma ciaglego, zjawiskiem przecieku widma i zwiekszaniem rozdzielczosci czestotliwosciowej



Np = 64;	% ilosc probek sygnalu sin

f = 8.5;	% czestotliwosc sygnalu

fs = 254;	% czestotliwosc probkowania

N = Np;		% dlugosc sygnalu (domyslnie N = Np)



% wybor analizowanego fragmentu

pocz = 1;	% poczatek fragmentu (domyslnie 1)

kon = N;	% koniec fragmentu   (domyslnie N)



k = f*N/fs;	% ilosc obserowowanych okresw



% generowanie sygnalu

xs = sin(2*pi*f*(1:Np)/fs);

x = zeros(1,1:N);

x = [xs,zeros(1,N-Np)];		% uzupelnienie sygnalu zerami



% wizualizacja sygnalu

clf;plot(x,'r-',x,'b5');pause;



% obliczanie FFT

X = fft(x);

disp(["rozdzielczosc widmowa: ",num2str(fs/N)," [Hz]"]);



%----------- wersja Rozszerzona (,,gladsze'' wykresy)

% obliczanie rozkladu ciaglego

m = 1:0.1:N;

lenM = length(m);

XCont = zeros(1,lenM);

n = 1:lenM;

XCont(n) = abs( (Np/2) * (sin(pi*(k-m(n))))./(pi*(k-m(n))) );



oneplot;clf

#plot([0 kon],[0 Np/2],'b.');hold "on"		% zamiast axis



% kreslenie widma dyskretnego

plot(n(pocz:kon)-1,abs(X(pocz:kon)),'b^',...
 
n(pocz:kon)-1,abs(X(pocz:kon)),'b6');

hold "on";



% kreslenie widma ciaglego

poczCont = find(m == pocz);

konCont = find(m == kon);

grid "on";

plot(m(poczCont:konCont),XCont(poczCont:konCont),'m-');





%----------- wersja podstawowa

%  % obliczanie rozkladu ciaglego

%  m = 1:N;

%  XCont = zeros(1,length(m));

%  XCont(m) = abs((Np/2) * (sin(pi*(k-(m-1))))./(pi*(k-(m-1))));

%

%  % kreslenie widma dyskretnego

%  oneplot;clf;clg;

%  plot([0 kon],[0 Np/2],'b.');hold "on"		% zamiast axis

%  plot(m(pocz:kon)-1,abs(X(pocz:kon)),'b^',m(pocz:kon)-1,abs(X(pocz:kon)),'b5');

%  hold "on";

%  grid "on"

%

%  % kreslenie widma ciaglego

%  plot(m(pocz:kon)-1,XCont(pocz:kon),'m-');
