%BAZA1 wizualizacja funkcji bazowych.
%
% Wykresy prezentuja funkcje bazowe rozdzielone na czesc rzeczywista i urojona
%

% parametry
N = 8;				% ilosc punktow transformaty (=dlugosc sygnalu)
fs = 8000;			% czestotliwosc probkowanie
mnoznik = 5;		% zageszczenie probek dla reprezentacji ,,ciaglej''
SKAL = 0.4;			% wspolczynnik skalujacy amplitudy

n = 1:N;				% indeksy prbek
nContSize = mnoznik*N;	% dlugosc wektora z indeksami reprezentacji ,,ciaglych''
nCont = linspace(1,N,nContSize);	% indeksy dla ,,ciaglych'' wersji sygnalow

% inicjalizacja macierzy z wektorami przestrzeni bazowej
mSize = N;
B 	= zeros(mSize, N);
BCont 	= zeros(mSize, nContSize);

% ---------------- Obliczanie bazy
m = 1:N;
B(m,n) = exp(-i*2*pi*(m-1)'*(n-1)/N);
 
  for iM= 1:mSize
  	for iN = 1:nContSize
		BCont(iM,iN) = exp(-i*2*pi*(m(iM)-1)*(nCont(iN)-1)./N);
  	endfor
  endfor;
  
	
% --------------- Wizualizacja bazy - uproszczone, ale na jednym wykresie

clf;clg;multiplot(1,2);
subplot(1,2,1);clg;
title(["baza - czesc rzeczywista\n(amplitudy przeskalowane\nSKAL= ",num2str(SKAL),")"]);
ylabel("m");

for iM = 1:mSize
	plot(nCont,SKAL*real(BCont(iM,:))+iM-1,'b-');hold "on"
    plot(m,SKAL*real(B(iM,:))+iM-1,'ro');
endfor
grid "on"; legend "off";replot

subplot(1,2,2);clg;
title(["baza - czesc urojona\n(amplitudy przeskalowane\nSKAL= ",num2str(SKAL),")"]);
ylabel("m");
for iM = 1:mSize
	plot(nCont,SKAL*imag(BCont(iM,:))+iM-1,'b-');hold "on"
	plot(m,SKAL*imag(B(iM,:))+iM-1,'ro');    
endfor
grid "on"; legend "off";replot
