%  
% COREL - wyznaczenie korelacji dwoch sygnalow
%
% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005

clear *;

% czyszczenie ekranu graficznego
subplot(1,1,1),clg;

% czestotliwosc probkowania
fp = 200;

% wektor czasu
t = [0:1000]./fp;

% dlugosc wektora czasu
N = length(t);

% pierwszy sygnal - sinus 1 Hz
x = sin(2*pi*1*t);

% generacja szumu gausowskiego
szum = randn(1,N); szum = szum / max(szum);

% drugi sygnal - zaszumiony sinus
y = -x;

% korelacja sygnalow x i y
[Rxy k] = xcorr(x,y);

	% wizualizacja sygnalow 	
	subplot(1,1,1),clg;
	xlabel("czas"); ylabel("wartosci");
	subplot(3,1,1);
	plot(t,x,"-r;syg x(n);");
	subplot(3,1,2);
	plot(t,y,"-r;syg y(n);")
	subplot(3,1,3);
	plot(k/fp,Rxy,"-b;korelacja Rxy(n);");
	
