% Funkcja generujca fraktal Mandelbrota
% skadnia funkcji:
% fractal(from_x, to_x, size_x, from_y, to_y, size_y, iter, k, color1, color2)
% from_x, to_x - przedzia wykrelania na osi x
% from_y, to_y - przedzia wykrelania na osi y
% size_x - ilo punktw na osi x
% size_y - ilo punktw na osi y
% iter - liczba iteracji algorytmu
% k - wykadnik potgi wzoru mandelbrota
% color1, color2 - schemat kolorow

% "zuczek" - fractal(-2,0.5,100,-1.15,1.15,100,256,2,0,1)

function [] = fractal(from_x, to_x, size_x, from_y, to_y, size_y, iter, k, color1, color2)
	printf("Fractal v0.4 (c)Karol Kozlowski\n\r");

	zeros(size_x, size_y);

	x = linspace(from_x, to_x, size_x);
	y = linspace(from_y, to_y, size_y);

	cmap = hsv2rgb([linspace(color1, color2, iter)', ones(iter, 2)]);
	cmap(end, :) = 0;

	clear i; 

	fract = zeros(size_x,size_y);
	for v = 1:size_y
		for u = 1:size_x
			z = 0; n = 0;
			c = x(u) + i*y(v);
			while (n < iter) & (abs(z) < 2)
				z = z^k+c;
				n++;
			end
			fract(v, u) = n;
		end
	end

	colormap(cmap);
	image(fract, 1);
end
