function [ac] = acor(X,tau)
%ACOR oblicza funkcje autokorelacji sygnalu dla danej ilosci punktow opoznienia
%	[ac] = ACOR(X,tau)
%
% Oblicza funkcje autokorelacji sygnalu stacjonarnego X
% dla tau punktow opoznienia. Podaje wynik dla dodatniej
% czesci osi opoznienia. Wykorzystuje estymator obciazony.
%
% Wejscie
%	X 	- sygnal stacjonarny
%	tau	- opoznienie
%
% Wyjscie
%	ac	- funkcja autokorelacji
%

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

[mx,nx]=size(X);
if (nx>mx)
	X=X.';
endif
len=max(mx,nx);
tau=min(len,tau);

ac=zeros(tau,1);

for k=(1:tau)
	ac(k)=X(1:len-k+1).'*X(k:len)/len;
endfor

endfunction