%AKORCUM3 wykresla estymatory parametrow sygnalu
%wykresla estymatory funkcji autokorelacji, gestosci prawdopodobienstwa i kumulanta 3-go rzedu dwoch procesow stacjonarnych

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 


N=2^10;		% dlugosc sygnalow
obc=0.5;	% wspolczynnik filtracji dolnoprzepustowej
		% (0 - cale pasmo, 1 - tylko skladowa stala)

% generacja pierwszego sygnalu - szum bialy gaussowski
syg1=randn(1,N);

% generacja drugiego sygnalu - szum bialy niegaussowski
syg2=randn(1,N).^4;		% zamien rozklad gaussowski na niegaussowski
syg2=syg2-mean(syg2);		% centruj
syg2=syg2/std(syg2);		% standaryzuj

% filtracja dolnoprzepustowa - filtracja zbliza rozklad niegaussowski
% sygnalu syg2 do rozkladu gaussowskiego, jednak po filtracji ma
% on nadal rozklad rozniacy sie od gaussowskiego
obc1=min(floor(obc*N/2),N/2-1);
fil=fft(syg1);
fil(N/2+1-obc1:N/2+1+obc1)=zeros(1,2*obc1+1);
syg1=real(ifft(fil));
fil=fft(syg2);
obc1=min(floor(obc*N/2),N/2-1);
fil(N/2+1-obc1:N/2+1+obc1)=zeros(1,2*obc1+1);
syg2=real(ifft(fil));

% oblicz funkcje autokorelacji
ac1=acor(syg1,30);
ac2=acor(syg2,30);

% oblicz kumulant 3-go rzedu
cm1=mom3(syg1,20,20);
cm2=mom3(syg2,20,20);

% rysuj wykresy
x=linspace(0,19,20);
[xx,yy]=meshgrid(x,x);
oneplot();
clg;
subplot(2,3,1);clg;
xlabel("tau");
ylabel("R(tau)");
plot((0:length(ac1)-1)',ac1,"-r;f-cja autokor.;");	% autokorelacja syg1

subplot(2,3,2);clg;
prdens(syg1,100);	% gestosc prawdop. syg1

subplot(2,3,3);clg;
xlabel("tau1");
ylabel("tau2");
zlabel("C3(tau1,tau2)");
mesh(xx,yy,cm1);	% cumulant 3-go rzedu syg1

subplot(2,3,4);clg;
xlabel("tau");
ylabel("R(tau)");
plot((0:length(ac2)-1)',ac2,"-r;f-cja autokor.;");	% autokorelacja syg1

subplot(2,3,5);clg;
prdens(syg2,100);	% gestosc prawdop. syg2

subplot(2,3,6);clg;
xlabel("tau1");
ylabel("tau2");
zlabel("C3(tau1,tau2)");
mesh(xx,yy,cm2);	% cumulant 3-go rzedu syg2
