%KORWZPRZYK generuje sygnaly i wykresla estymator ich funkcji korelacji wzajemnej

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

N=5000;				% dlugosc sygnalu
N_cor=50;			% dlugosc korelacji wzajemnej
h=[1 0 0 0 0.5 0 0 0 0.25];	% odpowiedz impulsowa generujaca echo
				% (nalozony jest sygnal przesuniety o 4
				% probki i stlumiony 2 razy oraz przesuniety
				% o 8 probek i stlumiony 4 razy)

% generuj sygnal 1 - szum bialy gaussowski
syg1=randn(1,N);

% generuj sygnal 2 - sygnal 1 z dodanym echem
syg2=filter(h,1,syg1);

% oblicz estymator autokorelacji syg1
ac1=acor(syg1,N_cor);

% oblicz estymator korelacji wzajemnej
cc12=crosscor(syg2,syg1,N_cor);

oneplot();
clg;
subplot(2,1,1);
xlabel("tau");
ylabel("R(tau)");
plot((-(length(ac1)-1):length(ac1)-1)',[flipud(ac1(2:end));ac1],"-r;f-cja autokor. syg1;");
subplot(2,1,2);
clg
xlabel("tau");
ylabel("R(tau)");
plot((-(length(cc12)-1)/2:(length(cc12)-1)/2)',cc12,"-r;f-cja kor. wzaj. syg1 i syg2;");