%LOKALIZACJA demonstruje zastosowanie korelacji wzajemnej do lokalizacji wzorca

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

clear;

% ustawienie progu na 90% maksimum f. korel. wzajemnej
TH = 0.9;

% Stopien wmocnienia wartosci powyzej progu 
% i tlumienia wartosci ponizej progu
K = 6;

% Wczytanie przykladowego obrazu (do zmiennej bw)
load('obraz.mat');

% Utworzenie wzorca poprzez wyciecie litery ,,a'' z obrazu
a_horiz = bw(32:45,88:98); %wzorzec tekstu pisanego poziomo
a_vert = flipud(a_horiz'); %wzorzec tekstu pisanego pionowo

% Wybor wzorca (poziomy/pionowy)
a = a_vert;
a = a_horiz;

figure(1); imagesc(bw); title('Przykladowy obraz');
disp('Przykladowy obraz');
disp("\tprzycisnij dowolny klawisz..."); pause;

figure(2); imagesc(a); title('Wzorzec');
disp('Wzorzec');
disp("\tprzycisnij dowolny klawisz..."); pause;

% obliczenie korelacji wzajemnej
C=xcorr2(bw,a);

figure(3); imagesc(C,[]);
title('Wartosci funkcji korelacji wzajemnej');
disp('Wartosci funkcji korelacji wzajemnej');
disp("\tprzycisnij dowolny klawisz..."); pause;

%------------------------------------------------
% ekstrakcja punktow o w ktrych funkcja korelacji wzajemnej ma wartosc
% wieksza od wartosci progowej
%------------------------------------------------

% znalezienie maksimum funkcji korelacji wzajemnej
mx=max(C(:));

%obliczenie warosci progowej
prog = TH * mx; 

% Wzmocnienie wartosci powyzej progu i tlumienie wartosci ponizej progu
% realizowane poprzez nieliniowe przeksztalcenie z wykorzystaniem funkcji
% eksponens
Cn = C./prog;		% wartosci powyzej progu beda wieksze od 1
Ctrans = exp(K*Cn);	% nieliniowe przeksztalcenie wynikow korelacji.
					% Stopien wmocnienia/tlumienia mozna regulowac stala ,,K''
figure(4); imagesc(Ctrans);
title('Po przeksztalceniu nieliniowym');
disp('Mapa korelacji po przeksztalceniu nieliniowym');
disp("\tprzycisnij dowolny klawisz..."); pause;
					
% wyswietlenie punktow dla ktorych f. korel. wazjemnej
% ma warotsc wieksza niz ustalona wartosc progowa
figure(5);
Cth = C > prog;		% Progowanie:
					%	(wartosci C >  prog)  -> 1
					%	(wartosci C <= prog)  -> 0
imagesc(Cth);
title('znalezione polozenia maksimow');
disp('Znalezione polozenia maksimow');


