% HISTOGRAMY2 wykresla estymaty rozkladu prawdopodobienstwa i dystrybuanty I-szego rzedu procesu
% y=alfa*t,
% gdzie alfa to zmienna losowa o rozkladzie jednostajnym na przedziale [0,1],
% zakres obserwacji t=[0,1]



% generacja wielu obserwacji i wykreslanie histogramow
% w wybranych punktach dyskretnej osi czasu

N=5000;				% liczba obserwacji
t1=2; t2=7;			% wybrane punkty obserwacji
t=linspace(0,1,10);		% przedzial obserwacji

disp("generacja wielu obserwacji i wykreslanie histogramow\n...
w wybranych punktach dyskretnej osi czasu\n\n");

% generacja obserwacji
syg=zeros(N,length(t));
for k=1:N
	alfa=rand(1);		% losuj alfa
	syg(k,:)=t*alfa;	% generuj sygnal
end

% wizualizacja czterech realizacji procesu
%for i = 1:4
%	subplot(2,2,i); clg; grid "on";
%	plot(syg(i,:),['-r;realizacja nr ',num2str(i),';']);
%endfor
%disp("nacisnij dowolny klawisz...\n\n");
%kbhit();
	
% rysuj wykresy
subplot(2,2,1);
clg;
title("pierwszy punkt na osi czasu");
prdens(syg(:,t1),100);

subplot(2,2,3);
clg;
title("drugi punkt na osi czasu");
prdens(syg(:,t2),100);

subplot(2,2,2);
clg;
title("pierwszy punkt na osi czasu");
prdist(syg(:,t1),100);

subplot(2,2,4);
clg;
title("drugi punkt na osi czasu");
prdist(syg(:,t2),100);

disp("nacisnij dowolny klawisz...\n\n");
kbhit();



% wykreslanie histogramu na podstawie jednej obserwacji

N=5000;			% dlugosc obserwacji
t=linspace(0,1,N);	% przedzial obserwacji

disp("wykreslanie histogramu na podstawie jednej obserwacji");

% generacja obserwacji
syg=zeros(1,N);
alfa=rand(1);		% losuj alfa
syg=t*alfa;		% generuj sygnal

% rysuj wykresy

disp("nacisnij dowolny klawisz...\n\n");
kbhit();


oneplot();
clg;
subplot(1,2,1);clg
title("histogram wykreslony\nna podstawie jednej obserwacji");
prdens(syg,100);
subplot(1,2,2);clg
title("dystrybuanta empiryczna wykreslona\nna podstawie jednej obserwacji");
prdist(syg,100);
