% HISTOGRAMY3 wykresla estymaty dwuwymiarowej gestosci prawdopodobienstwa procesu stacjonarnego y(t)
%tj. lacznej gestosci prawdopodobienstwa zmiennych losowych y(t) i y(t+tau) dla zadanego parametru tau

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

%N=2^13;		% dlugosc sygnalu (potega dwojki)	
%obc=0.25;	% wspolczynnik filtracji dolnoprzepustowej
		% (0 - cale pasmo, 1 - tylko skladowa stala)
%bin=25;		% ilosc przedzialow obliczania histogramow dla
		% zmiennych losowych y(t) i y(t+tau) 
%tau=0;		% odleglosc miedzy zmiennymi losowymi

% generuj sygnal
p=(1:N);
%p=p/N;
y=sin(p);

% obetnij gorna czesc pasma -> utworz korelacje miedzy
% zmiennymi losowymi y(t) i y(t+tau)
fil=fft(y);
obc=min(floor(obc*N/2),N/2-1);
fil(N/2+1-obc:N/2+1+obc)=zeros(1,2*obc+1);
y=real(ifft(fil));

% oblicz dwuwymiarowy znormalizowany histogram
nn=zeros(bin);
x=linspace(min(y)-10*eps,max(y),bin+1);
for k=1:N-tau
	xpos=sum(x<y(k));
	ypos=sum(x<y(k+tau));
	nn(xpos,ypos)=nn(xpos,ypos)+1;
endfor
nn=nn*((max(y)-min(y))/bin)^2;

% wykresl dwuwymiarowy histogram
[xx,yy]=meshgrid(x(1:end-1)+(x(2)-x(1))/2);
%oneplot();
clg
xlabel("wartosc zmiennej losowej\nw punkcie t");
ylabel("wartosc zmiennej losowej\nw punkcie t+tau");
zlabel("gestosc prawdopodobienstwa");
%subplot(2,2,1);
mesh(xx,yy,nn);
gset view 30,5
replot
