function prdist(x,n,cdf)
% PRDIST wykresla dystrybuante empiryczna ze zbioru obserwacji x, uzywajac n przedzialow
% opcjonalnie wykresla teoretyczna
% dystrybuante zadana funkcja pdf

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

% oblicz znormalizowany histogram
[nn, xx]=hist(x,n,1);

% oblicz dystrybuante empiryczna
nn=cumsum(nn);

% wykresl dystrybuante empiryczna
xlabel("wartosc zmiennej losowej");
ylabel("prawdopodobienstwo");
bar(xx,nn);

% opcjonalnie wykresl dystrybuante teoretyczna
if (nargin>2)
	hold on;
	t=linspace(min(x),max(x),200);
	plot(t,feval(cdf,t),"-b;dystrybuanta teoretyczna;");
	hold off;
endif

endfunction