%
% ALIASINGSIN pozwala eksperymentowac ze zjawiskiem powielania widma sygnalu sinusoidalnego
%
% Podstawy i algorytmy przetwarzania sygnalow
% semestr letni 2005
%

[x, fs] = auload('ktz.wav');
s=x;

FS = 100;	% czestotliwosc sygnalu [Hz]
FP = 250;	% czestotliwosc probkowania
T = 0.1;	% przedzial probkowania [s]

dt = 1/FP;	% okres probkowania


t_samp = 0:dt:T;			% chwile w ktorych pobierane sa probki
t_cont = 0:(1./(20*FS)):T;	% chwile probkowania dla sygnalu ,,ciaglego''

signalCont = sin (2*pi*FS*t_cont);	% sygnal ,,ciagly''
signalSamp = sin (2*pi*FS*t_samp);	% sygnal sprobkowany

subplot(221); clg
title(['Przebieg czasowy sygnalu sprobkowanego fs = : ',int2str(FS),', fp = ',int2str(FP)]);
xlabel('czas [s]');
ylabel('amplituda')
grid
% wykres sygnalu ,,ciaglego''
plot(t_cont,signalCont,'b-');
hold on
stem(t_samp,signalSamp);
hold off
legend('off')

subplot(222); clg
clg;
title("Modul widma");
xlabel("czestotliwosc [Hz]");
ylabel('Modul widma');
grid('on')
X = fftg(signalSamp,FP);
legend('off');

subplot(223); clg
clg;
title("Rekonstrukcja");
xlabel("czas [s]");
ylabel('Amplituda');
grid('on')
plot(t_samp,real(ifft(X)),'b-');
hold on
stem(t_samp,real(ifft(X)))
hold off
legend('off');

subplot(224); clg
clg;
title("Roznica przebiegu odtworzonego i sprobkowanego");
xlabel("czas [s]");
ylabel('Amplituda');
grid('on')
e = real(ifft(X)) - signalSamp;
plot(t_samp,e,'r-')
legend('off');