%
% RODZAJE demonstruje dyskretyzacje sygnalu
%
% Podstawy i algorytmy przetwarzania sygnalow
% semestr letni 2005
%

FS = 200;	% czestotliwosc sygnalu
FP = 4000;	% czestotliwosc probkowania
NB = 4;		% ilosc bitow przetwornika A/C
NT = 1;		% ilosc okresow sygnalu

% ilosc poziomow kwantowania
NL = 2^NB;
% przedzial probkowania
T = NT / FS;	
% okres probkowania
dt = 1/FP;
% momenty probkowania
tSamp = 0:dt:T;
% momenty dla sygnalu ,,ciaglego''
tCont = 0:1/(120*FS):T;

% sygnal ,,ciagly''
signalCont = sin(2*pi*FS.*tCont);
% sygnal sprobkowany (dyskretny w czasie)
signalSamp = sin(2*pi*FS.*tSamp);
% sygnal skwantowany
signalQuant = (round(signalCont*(NL-1)))./(NL-1);
%signalQuant = (floor(signalCont*(NL-1)))./NL;
% sygnal sprobkowany i skwantowany
signalDigit = (round(signalSamp*(NL-1)))./(NL-1);
%signalDigit = (floor(signalSamp*(NL-1)))./NL;

subplot(2,2,1); clg;
title('ciagly');
xlabel('czas [s]');
plot(tCont,signalCont,'r-')
hold off

subplot(2,2,2); clg;
title('sprobkowany');
xlabel('czas [s]');
plot(tSamp,signalSamp,'c^')
hold on
plot(tSamp,signalSamp,'rx')
plot(tCont,signalCont,'b-')
hold off

subplot(2,2,3); clg;
title('skwantowany');
xlabel('czas [s]');
axis([0,T,-1,1])
plot(tCont,signalQuant,'rL')
plot(tCont,signalCont,'b-')
hold off

subplot(2,2,4); clg;
title('sprobkowany i skwantowany');
xlabel('czas [s]');
plot(tSamp,signalDigit,'c^')
hold on
plot(tSamp,signalDigit,'rx')
plot(tCont,signalCont,'b-')
hold off