function wsound (x, fs)

# Funkcja odtwarza dzwiek korzystajac z Windows Media Playera
#
# Wejscie:
#
# x  - Sygnal do odtworzenia. Wiersze powinny zawierac kolejne probki,
#      a kolumny kolejne kanaly. Dopuszczalne sa max. 2 kanaly. Sygnal
#      musi zawierac wartosci probek z przedzialu [-1; 1].
#
# fs - Czestotliwosc probkowania. Domyslnie 8 kHz.
#

if (nargin == 0 || nargin > 2)
  usage('wsound(x, fs), x - sygnal, fs - czest. probk. (domyslnie 8 kHz)');
elseif (nargin == 1)
  fs = 8000;
end

# domyslnie liczba kanalow mniejsza niz liczba probek
s=size(x);
if (s(2) > s(1))
  x=x';
  s=fliplr(s);
end

# co najwyzej dwa kanaly
if (s(2) > 2)
  x=x(:,1:2);
end

# ogranicz amplitude
x=clip(x,[-1 1]);

# zapisz plik tymczasowy
tname= tmpnam();
fslash= find (tname == '\\');
tname(fslash) = '/';
wav_name = [tname , ".wav"]; 
ausave(wav_name,x,fs);

# wywolaj media playera
system(['mplay32 /play /close ' , wav_name ]);

# zaznacz plik tymczasowy do usuniecia
eval('mark_for_deletion(wav_name)','');

end 