' Demo.vb : 
'EquTranslator algorithm
'Copyright  2001-2005 Easy Math Solution. All Rights Reserved
'http://www.e-MathSolution.com
'For details contact us: info@e-MathSolution.com

Module Module1

    Sub Main()
        On Error GoTo errHnd
        Dim expr As String
        Dim arg(3) As Double
        Dim res As Double
        Dim tr As EMS.EquTranslator
        Dim qb As EMS.EquTranslator.CallBackUserFunction

        tr = New EMS.EquTranslator()
        arg(0) = 3
        arg(1) = 5.6
        arg(2) = 15.6
        expr = "f(x,y,z)=qub(x)+x*(-y)+5.4789*exp(sqrt(x/(y)))/(y-x*z)"

        qb = New EMS.EquTranslator.CallBackUserFunction(AddressOf qub)
        tr.AddFunction("qub", qb)

        tr.SetEquTranslatorException()

        res = tr.EvaluateEqu(expr, arg(0))
        System.Console.WriteLine("res={0}", res)

        res = tr.Evaluate("x,y", "qub(x)+exp(y)", arg(0))
        System.Console.WriteLine("res={0}", res)

        tr.RemoveFunction("qub")
        res = tr.Evaluate("x y", "qub(x/sqrt(y))+exp(y)", arg(0))
        System.Console.WriteLine("res={0}", res)

errHnd:  'Error
        System.Console.WriteLine(Err.Description)

    End Sub

    'User defined function
    Function qub(ByRef x As Double) As Double
        qub = x * x * x
    End Function
End Module
