'EquTranslator.vb
'Copyright  2001-2005 Easy Math Solution. All Rights Reserved
'http://www.e-MathSolution.com
'For details contact us: info@e-MathSolution.com

Imports System.Runtime.InteropServices
Namespace EMS
    Public Class EquTranslator
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
                  CharSet:=CharSet.Ansi)> _
               Public Shared Function EvaluateEqu(ByVal exp As String, ByRef args As Double) As Double
        End Function
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
               Public Shared Function Evaluate(ByVal arg As String, ByVal exp As String, ByRef args As Double) As Double
        End Function
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
                Public Shared Sub BuildEqu(ByVal arg As String)
        End Sub
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
             Public Shared Sub Build(ByVal arg As String, ByVal exp As String)
        End Sub
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
          Public Shared Function CalcFor(ByRef args As Double) As Double
        End Function


        Public Delegate Function CallBackUserFunction(ByRef val As Double) As Double
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
         Public Shared Function AddFunction(ByVal fnName As String, ByVal lpFunc As CallBackUserFunction) As Boolean
        End Function
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
         Public Shared Function RemoveFunction(ByVal fnName As String) As Boolean
        End Function

        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
            Public Shared Function AddConst(ByVal constName As String, ByVal val As Double) As Boolean
        End Function
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
         Public Shared Function RemoveConst(ByVal constName As String) As Boolean
        End Function

        Public Delegate Sub CallBackDelegate(ByVal constName As String)
        <DllImport("EquTranslator.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Ansi)> _
            Public Shared Sub SetErrorHandle(ByVal errDgt As CallBackDelegate)
        End Sub


        Public Sub SetEquTranslatorException()
            Dim errD As CallBackDelegate
            errD = New CallBackDelegate(AddressOf RiseException)
            SetErrorHandle(errD)
        End Sub

        Private Sub RiseException(ByVal err As String)
            Throw New Exception(err)
        End Sub

    End Class


    '//////////////////////////////////////////////////////////////////////////////////
    '//The UNICODE implementation of the EquTranslator algorithm
    Public Class EquTranslatorW
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
                  CharSet:=CharSet.Unicode)> _
               Public Shared Function EvaluateEqu(ByVal exp As String, ByRef args As Double) As Double
        End Function
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
               Public Shared Function Evaluate(ByVal arg As String, ByVal exp As String, ByRef args As Double) As Double
        End Function
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
                Public Shared Sub BuildEqu(ByVal arg As String)
        End Sub
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
             Public Shared Sub Build(ByVal arg As String, ByVal exp As String)
        End Sub
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
          Public Shared Function CalcFor(ByRef args As Double) As Double
        End Function


        Public Delegate Function CallBackUserFunction(ByRef val As Double) As Double
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
         Public Shared Function AddFunction(ByVal fnName As String, ByVal lpFunc As CallBackUserFunction) As Boolean
        End Function
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
         Public Shared Function RemoveFunction(ByVal fnName As String) As Boolean
        End Function

        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
            Public Shared Function AddConst(ByVal constName As String, ByVal val As Double) As Boolean
        End Function
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
         Public Shared Function RemoveConst(ByVal constName As String) As Boolean
        End Function

        Public Delegate Sub CallBackDelegate(ByVal constName As String)
        <DllImport("EquTranslatorW.dll", CallingConvention:=CallingConvention.StdCall, _
            CharSet:=CharSet.Unicode)> _
            Public Shared Sub SetErrorHandle(ByVal errDgt As CallBackDelegate)
        End Sub


        Public Sub SetEquTranslatorException()
            Dim errD As CallBackDelegate
            errD = New CallBackDelegate(AddressOf RiseException)
            SetErrorHandle(errD)
        End Sub

        Private Sub RiseException(ByVal err As String)
            Throw New Exception(err)
        End Sub

    End Class


End Namespace

