// Demo.cpp : 
//EquTranslator algorithm
//Copyright  2001-2005 Easy Math Solution. All Rights Reserved
//http://www.e-MathSolution.com
//For details contact us: info@e-MathSolution.com

using System;
using EMS;


namespace CSH_test
{
	class Test
	{
		//User defined function (grades to radians).
		static double toRad(ref double x)
		{
			return 3.14*x/180;
		}

		[STAThread]
		static void Main(string[] args)
		{
			double [] arg= new double[2];
			double res=0;
			string mExp="f(x,y)=x+(5+y)^2-exp(x)+sqrt(toRad(x*y))";
			arg[0]=5; arg[1]=6;

			EMS.EquTranslator.CallBackUserFunction tRd=
				new EMS.EquTranslator.CallBackUserFunction(toRad);
			try
			{
				//Set the error handle
				EMS.EquTranslator.SetEquTranslatorException(); 
				EMS.EquTranslator.AddConst("pi2", 6.28);   
				EMS.EquTranslator.AddFunction("toRad", tRd); 

				EMS.EquTranslator.BuildEqu("f(x,y)=sqrt(pi2/x)+exp(toRad(x-y))");
				res=EMS.EquTranslator.CalcFor(arg);
				Console.WriteLine("res={0}", res);
				
				Console.WriteLine("res={0}",
					EMS.EquTranslator.EvaluateEqu(mExp, arg));

				EMS.EquTranslator.RemoveConst("pi2");
				Console.WriteLine("res={0}",
					EMS.EquTranslator.Evaluate("x,y","exp(pi2/x)^(y/(5+x))", arg));
			} 
			catch(Exception e)
			{
				Console.WriteLine(e.Message);
			}

		}
	}
}
