//EquTranslator.cs
//Copyright  2001-2005 Easy Math Solution. All Rights Reserved
//http://www.e-MathSolution.com
//For details contact us: info@e-MathSolution.com

using System.Runtime.InteropServices;

namespace EMS
{
	public class EquTranslator
	{
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static  double EvaluateEqu(string exp, double [] arg); 
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static double Evaluate(string arg, string exp, double [] argVal); 

		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static  void BuildEqu(string mExp);
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static  void Build(string arg, string exp);
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public  extern static  double CalcFor(double [] arg);


		public  delegate  double  CallBackUserFunction(ref double val);
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public   extern static bool AddFunction(string funName,CallBackUserFunction fn);
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static bool RemoveFunction(string exp);

		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static bool AddConst(string exp, double val);
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public extern static bool RemoveConst(string exp);


		// Declaring Delegate for Callback Function
		public delegate void CallBackDelegate(string err);
		[DllImport("EquTranslator.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Ansi)]
		public static extern void  SetErrorHandle(CallBackDelegate dl);

	
		public static void SetEquTranslatorException()
		{
			CallBackDelegate errrBkCallFunc = new CallBackDelegate(RiseException);			
			SetErrorHandle(errrBkCallFunc);
		}

		static void RiseException(string err)
		{
			throw new System.Exception(err);
		}

	}



	////////////////////////////////////////////////////////////////////
	/////
	///
	public class EquTranslatorW
	{
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static  double EvaluateEqu(string exp, double [] arg); 
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static double Evaluate(string arg, string exp, double [] argVal); 

		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static  void BuildEqu(string mExp);
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static  void Build(string arg, string exp);
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public  extern static  double CalcFor(double [] arg);


		public  delegate  double  CallBackUserFunction(ref double val);
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public   extern static bool AddFunction(string funName,CallBackUserFunction fn);
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static bool RemoveFunction(string exp);

		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static bool AddConst(string exp, double val);
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public extern static bool RemoveConst(string exp);


		// Declaring Delegate for Callback Function
		public delegate void CallBackDelegate(string err);
		[DllImport("EquTranslatorW.dll",CallingConvention=CallingConvention.StdCall,
			 CharSet=CharSet.Unicode)]
		public static extern void  SetErrorHandle(CallBackDelegate dl);

	
		public static void SetEquTranslatorException()
		{
			CallBackDelegate errrBkCallFunc = new CallBackDelegate(RiseException);			
			SetErrorHandle(errrBkCallFunc);
		}

		static void RiseException(string err)
		{
			throw new System.Exception(err);
		}

	}
}


