//EquTranslatorEx.h
//Copyright  2001-2005 Easy Math Solution. All Rights Reserved
//http://www.e-MathSolution.com
//For details contact us: info@e-MathSolution.com
#ifndef EQUTRANSLATOREX_H
#define EQUTRANSLATOREX_H

#include<TCHAR.H>
#include<windows.h>
#include<string>


//The type definitions
typedef double TCalc;
typedef void (__stdcall*TpfErrorHandler)(const TCHAR*); //CallBack function to handle the errors
typedef const TCalc (__stdcall *MATHFUNCTION_PTR)(const TCalc &); //Math functions. User defined functions



typedef TCalc (__stdcall* TEvaluateEqu)(const TCHAR *exp, const TCalc *args);
typedef TCalc (__stdcall* TEvaluate)(const TCHAR *arg, const TCHAR *exp,
                                                const TCalc *args );
typedef void (__stdcall* TBuildEqu)(const TCHAR *exp);
typedef void (__stdcall* TBuild)(const TCHAR *arg, const TCHAR *exp);
typedef TCalc (__stdcall* TCalcFor)(TCalc *args);
typedef bool (__stdcall* TAddFunction)(const TCHAR *exp, MATHFUNCTION_PTR);
typedef bool (__stdcall* TRemoveFunction)(const TCHAR *exp);
typedef bool (__stdcall* TAddConst)(const TCHAR *exp, TCalc val);
typedef bool (__stdcall* TRemoveConst)(const TCHAR *exp);
typedef void (__stdcall* TSetErrorHandle)(TpfErrorHandler);




//External variables
extern  TEvaluateEqu            EvaluateEqu;
extern  TEvaluate               Evaluate;
extern  TBuildEqu       	BuildEqu;
extern  TBuild                  Build;
extern  TCalcFor                CalcFor;
extern  TAddFunction            AddFunction;
extern  TRemoveFunction         RemoveFunction;
extern  TAddConst               AddConst;
extern  TRemoveConst            RemoveConst;
extern  TSetErrorHandle         SetErrorHandle;


//Load & UnLoad EquTranslator.dll
bool LoadEquTranslator(void);
void UnLoadEquTranslator(void);


//////////////////////////////////////////////////////////////////////
//Exception class
class EquException {
	typedef std::basic_string<TCHAR>	STRING;
	const STRING err;
public:
	EquException(const TCHAR* _err): err(_err) {}
	EquException(const TCHAR* err1, const TCHAR * err2)
		: err( STRING(err1)+STRING(err2)) {}
	const STRING& what(void)const { return err; }
};

#endif