#ifndef EQUTRANSLATOR_H
#define EQUTRANSLATOR_H



#pragma warning(disable:4786) 

#include <string>
#include <TCHAR.H>

//Type definition
typedef double TCalc;  

typedef void (__stdcall*TpfErrorHandler)(const TCHAR*); //CallBack function to handle the errors
typedef const TCalc (__stdcall *MATHFUNCTION_PTR)(const TCalc &); //Math functions. User defined functions


//////////////////////////////////////////////////////////////////////
// Interface
//////////////////////////////////////////////////////////////////////
	TCalc __stdcall EvaluateEqu(const TCHAR *exp, const TCalc *args ); 
	TCalc __stdcall Evaluate(const TCHAR *arg, const TCHAR *exp, const TCalc *args ); 

	void __stdcall  BuildEqu(const TCHAR *exp);
	void __stdcall Build(const TCHAR *arg, const TCHAR *exp);
	TCalc __stdcall CalcFor(const TCalc *args);

	
	bool __stdcall AddFunction(const TCHAR*exp, MATHFUNCTION_PTR);
	bool __stdcall RemoveFunction(const TCHAR*exp);
	bool __stdcall AddConst(const TCHAR*exp, TCalc);
	bool __stdcall RemoveConst(const TCHAR*exp);

	 void __stdcall SetErrorHandle(TpfErrorHandler);

	 void __stdcall InitEquTranslator(void);
	 void __stdcall CloseEquTranslator(void);

	 


//////////////////////////////////////////////////////////////////////
//Exception class/////////////////////////////////////////////////////
class EquException {
	typedef std::basic_string<TCHAR>	STRING;
	const STRING err;
public:
	EquException(const TCHAR* _err): err(_err) {}
	EquException(const TCHAR* err1, const TCHAR * err2)
		: err( STRING(err1)+STRING(err2)) {}
	const STRING& what(void)const { return err; }
};


#endif