(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4711,        138]*)
(*NotebookOutlinePosition[      5356,        160]*)
(*  CellTagsIndexPosition[      5312,        156]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \(Simplify[
      Solve[0 == kg*\((Tgsr0\  - \ Tw0)\)\  - \ 
            kstr\ *\ \((Tw0 - Tzew0)\)\  + \ Qd0, 
        Tw0]]\), "\[IndentingNewLine]", 
    \(Simplify[
      Solve[{0 == 
            kg*\((Tgsr0\  - \ Tw0)\)\  - \ kstr\ *\ \((Tw0 - Tzew0)\)\  + \ 
              Qd0, 0 \[Equal] \ 
            2*cpw*ew*fN*\((Tgz0 - Tgsr0)\) - kg \((Tgsr0 - Tw0)\)}, {Tw0, \ 
          Tgsr0}]]\)}], "Input"],

Cell[BoxData[
    \({{Tw0 \[Rule] \(Qd0 + kg\ Tgsr0 + kstr\ Tzew0\)\/\(kg + kstr\)}}\)], \
"Output"],

Cell[BoxData[
    \({{Tw0 \[Rule] \(kg\ \((Qd0 + kstr\ Tzew0)\) + 2\ cpw\ ew\ fN\ \((Qd0 + \
kg\ Tgz0 + kstr\ Tzew0)\)\)\/\(kg\ kstr + 2\ cpw\ ew\ fN\ \((kg + kstr)\)\), 
        Tgsr0 \[Rule] \(2\ cpw\ ew\ fN\ kstr\ Tgz0 + kg\ \((Qd0 + 2\ cpw\ ew\ \
fN\ Tgz0 + kstr\ Tzew0)\)\)\/\(kg\ kstr + 2\ cpw\ ew\ fN\ \((kg + kstr)\)\)}}\
\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      RowBox[{
        RowBox[{"Simplify", "[", 
          
          StyleBox[\(LaplaceTransform[
              D[Cvw\ *\ Tw \((t)\), t]\  == \ 
                kg*\((Tgsr \((t)\)\  - \ Tw \((t)\))\)\  - \ 
                  kstr\ *\ \((Tw \((t)\) - Tzew \((t)\))\)\  + \ Qd0, t, s]\),
            
            "MR"], 
          StyleBox["]",
            "MR"]}], "\[IndentingNewLine]", 
        RowBox[{
          StyleBox[
            RowBox[{"S", 
              StyleBox["implify",
                "MR"]}]], 
          "[", \(LaplaceTransform[
            D[Cvg*\ Tgsr \((t)\), 
                t]\  == \ \ 2*cpw*ew*
                  f \((t)\)*\((Tgz \((t)\) - Tgsr \((t)\))\) - 
                kg \((Tgsr \((t)\) - Tw \((t)\))\), t, s]\), 
          "]"}]}]}]], "Input"],

Cell[BoxData[
    \(\(Qd0\ s + kg\ Tgsr - kg\ Tw - kstr\ Tw - Cvw\ s\ Tw + kstr\ Tzew\)\/s \
\[Equal] 0\)], "Output"],

Cell[BoxData[
    \(\(4\ cpw\ ew\ f\ \((Tgsr - Tgz)\) + s\ \((Cvg\ s\ Tgsr + kg\ \((Tgsr - \
Tw)\))\)\)\/s \[Equal] 0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
      Solve[{\(Qd0\ s + kg\ Tgsr - kg\ Tw - kstr\ Tw - Cvw\ s\ Tw + kstr\ \
Tzew\)\/s \[Equal] 
            0, \(4\ cpw\ ew\ f\ \((Tgsr - Tgz)\) + s\ \((Cvg\ s\ Tgsr + kg\ \
\((Tgsr - Tw)\))\)\)\/s \[Equal] 0}, {Tw, Tgsr}]]\)], "Input"],

Cell[BoxData[
    \({{Tw \[Rule] \(s\ \((kg + Cvg\ s)\)\ \((Qd0\ s + kstr\ Tzew)\) + 4\ cpw\
\ ew\ f\ \((Qd0\ s + kg\ Tgz + kstr\ Tzew)\)\)\/\(4\ cpw\ ew\ f\ \((kg + kstr \
+ Cvw\ s)\) + s\ \((Cvg\ s\ \((kstr + Cvw\ s)\) + kg\ \((kstr + \((Cvg + Cvw)\
\)\ s)\))\)\), 
        Tgsr \[Rule] \(4\ cpw\ ew\ f\ \((kstr + Cvw\ s)\)\ Tgz + kg\ \((Qd0\ \
s\^2 + 4\ cpw\ ew\ f\ Tgz + kstr\ s\ Tzew)\)\)\/\(4\ cpw\ ew\ f\ \((kg + kstr \
+ Cvw\ s)\) + s\ \((Cvg\ s\ \((kstr + Cvw\ s)\) + kg\ \((kstr + \((Cvg + Cvw)\
\)\ s)\))\)\)}}\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 747}},
WindowSize->{1158, 691},
WindowMargins->{{2, Automatic}, {Automatic, -1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 426, 10, 50, "Input"],
Cell[2205, 65, 100, 2, 44, "Output"],
Cell[2308, 69, 344, 5, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2689, 79, 827, 23, 70, "Input"],
Cell[3519, 104, 117, 2, 42, "Output"],
Cell[3639, 108, 131, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3807, 115, 266, 5, 42, "Input"],
Cell[4076, 122, 535, 8, 83, "Output"]
}, Open  ]],
Cell[4626, 133, 26, 0, 30, "Input"],
Cell[4655, 135, 52, 1, 50, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

