%% Czyszczenie
clear

%% Parametry obiektu
PgN     =  5000;                    %moc nominalna pieca
TwN     =    20;                    %temp wewn
TgzN	=    90;                    % TgzN/TgpN = 90/70
TgpN	=    70;
TzewN   =   -20;                    %temp zewn

cpw     =	4175;                   %cieplo wlasciwe wody
ew		= 	1000;                   %gestosc wody
Vg		=	0.1 * 1 * 1;            %objetosc grzejnika
Cvg     =	cpw * ew * Vg;          %pojemnosc cieplna

cpp     =	1000;                   %cieplo wlasciwe powietrza
ep		= 	1.2;                    %gestosc pow
Vw		=	3 * 3 * 2.5;            %objetosc pomieszczenia
Cvw     =	cpp * ep * Vw;          %pojemnosc cieplna

TgsrN	=	(TgzN + TgpN)/2;        %średnia nominalna temp grzejnika
kg		=	PgN / (TgsrN - TwN);	%wsp wymiany - grzejnik pow
kstr	=	PgN / (TwN - TzewN);	%wsp strat
fN      =   PgN / (2 * cpw * ew * (TgzN - TgsrN));

%% Warunki Początkowe
Qd0     =   0;                      %ciepła dodatkowe
f0      =   fN;                     %przepływ wody w grzejniku
Tgz0    =   TgzN;                   %temp grzejnika            
Tzew0	=	TzewN;                  %temp zewnętrzna

%średnia temp grzejnika
Tgsr0   = (2 * cpw * ew * fN * kstr * Tgz0 + kg * (Qd0 + 2 * cpw * ew * fN * Tgz0 + kstr * Tzew0))/(kg * kstr + 2 * cpw * ew * fN * (kg + kstr));
%średnia temp wnętrza
Tw0     = (Qd0 + kg * Tgsr0 + kstr * Tzew0) / (kg + kstr);

%% Zakłocenia
Qd1     =   Qd0;  
Tgz1    =   Tgz0;                   %temp grzejnika
Tzew1	=	Tzew0;                  %temp zewnętrzna
f1      =   f0;                     %przepływ wody w grzejniku

%% Parametry regulatora
Tw_z0    =   20;                    % SP
Tw_z1    =   Tw_z0-2;

PI_k    =   0.000002;               % wzmocnienie
PI_Ti   =   1000000000;             % stała czasowa

%% Symulacja
simtime =   25000;
simstep =   1;
t1      =   2500;                   %czas zakłócenia

model	=	'sim1_model';
sim(model);

cla;
hold on;
plot(t, 100*f/fN,'g','LineWidth',2);
plot(t,Tgsr,'--r','LineWidth',2);
plot(t,Tw,'-.b','LineWidth',2);
plot(t, SP,'k','LineWidth',1);

xlabel('czas [s]');
ylabel('temperatura [C]');
legend('f(t) [%]', 'T_{gsr}(t)', 'T_{w}(t)', 'SP(t)');

grid on;