% function [] = plot_train(classif)
%
% plots training functions for given classifier


function [] = plot_train(classif)

    colorspace = 'rgbcmyk';

    if (classif(size(classif,1)).type == 'norm')
    
        hold on;
    
        for a = 1:size(classif,1)
         
            plot(classif(a).trecord.perf,colorspace( mod( a-1,size(colorspace,2) )+1 ));
        
        end
       
        hold off;
    

    elseif (classif(size(classif,1)).type == 'bagg')
        [k, n] = size(classif);
          
        scheme(01,:) = [1 1];
        scheme(02,:) = [2 1];
        scheme(03,:) = [2 2];
        scheme(04,:) = [2 2];
        scheme(05,:) = [3 2];
        scheme(06,:) = [3 2];
        scheme(07,:) = [3 3];
        scheme(08,:) = [3 3];
        scheme(09,:) = [3 3];
        scheme(10,:) = [4 3];
        scheme(11,:) = [4 3];
        scheme(12,:) = [4 3];
        scheme(13,:) = [4 4];
        scheme(14,:) = [4 4];
        scheme(15,:) = [4 4];
        scheme(16,:) = [4 4];
        
        for i = 1:k
            
            subplot(scheme(k,1),scheme(k,2),i);
            hold on;
            grid on;
            title(['Fold: ' num2str(i)]);
            for a = 1:n
                plot(classif(i,a).trecord.perf,colorspace( mod( a-1,size(colorspace,2) )+1 ));
            end
            hold off;
        end

    else
        
        display('Que?');
        
    end

end