%DATA2IM Convert PRTools dataset to image
%
%		IM = DATA2IM(A)
%
% INPUT
%		A     Dataset containing images
%
% OUTPUT
%		IM    X*Y*K matrix containing a set of K images of X-by-Y pixels
%
% DESCRIPTION
% An image, or a set of images stored in the objects or features of the
% dataset A are retrieved and returned as a 3D matrix IM.
%
% SEE ALSO
% DATASETS, IM2OBJ, IM2FEAT

% Copyright: R.P.W. Duin, duin@ph.tn.tudelft.nl
% Faculty of Applied Sciences, Delft University of Technology
% P.O. Box 5046, 2600 GA Delft, The Netherlands

% $Id: data2im.m,v 1.5 2006/05/24 14:27:38 duin Exp $

function im = data2im (a)

	prtrace(mfilename);

	isdataim(a);			% Assert that A contains image(s).

	data = +a;				% Extract data from dataset, for computational advantage.
	[m,k] = size(a); [objsize,featsize] = get(a,'objsize','featsize');

	% Reshape data into output array.

	if (isfeatim(a))	
		% A contains K images stored as features (each object is a pixel).
		if length(objsize) == 2
			im = zeros(objsize(1),objsize(2),k);
			for j = 1:k
				im(:,:,j) = reshape(data(:,j),objsize(1),objsize(2));
			end
		elseif length(objsize) == 3
			im = zeros(objsize(1),objsize(2),objsize(3),k);
			for j = 1:k
				im(:,:,:,j) = reshape(data(:,j),objsize(1),objsize(2),objsize(3));
			end
		else
			error('Unable to handle these images')
		end
			
	else							
		
		% A contains M images stored as objects (each feature is a pixel).
		if length(featsize) == 2
			im = zeros(featsize(1),featsize(2),1,m);
			for j = 1:m
				im(:,:,1,j) = reshape(data(j,:),featsize(1),featsize(2));
			end
		elseif length(featsize) == 3
			im = zeros(featsize(1),featsize(2),featsize(3),m);
			for j = 1:m
				im(:,:,:,j) = reshape(data(j,:),featsize(1),featsize(2),featsize(3));
			end
		else
			error('Unable to handle these images')
		end
	end

return
