echo on
clc
%	This example demonstrates fitting a nonlinear function to a
%	set of data.  We'll use a function called FMINS that implements
%	the Nelder-Mead simplex algorithm for minimizing a nonlinear
%	function of several variables.

%	Consider the following data:

pause	% Strike any key to continue.

global Data
Data = ...
  [ 0.0000    5.8955
    0.1000    3.5639
    0.2000    2.5173
    0.3000    1.9790
    0.4000    1.8990
    0.5000    1.3938
    0.6000    1.1359
    0.7000    1.0096
    0.8000    1.0343
    0.9000    0.8435
    1.0000    0.6856
    1.1000    0.6100
    1.2000    0.5392
    1.3000    0.3946
    1.4000    0.3903
    1.5000    0.5474
    1.6000    0.3459
    1.7000    0.1370
    1.8000    0.2211
    1.9000    0.1704
    2.0000    0.2636];

%	Let's plot this data.

pause	% Strike any key for plot.
t = Data(:,1);
y = Data(:,2);
plot(t,y,'o'), title('Input data'), pause
clc
%	We would like to fit the function
%
%	  y =  c(1)*exp(-lam(1)*t) + c(2)*exp(-lam(2)*t)
%
%	to the data.  This function has 2 linear parameters
%	and 2 nonlinear parameters.

%	To fit this function to the data, we write a function, called
%	say FITFUN, that, given the nonlinear parameters lam and the data,
%	returns the error in the fit.  We can then guess for initial
%	estimates of the nonlinear parameters, and invoke FMINS:

lam = [1 0]'; 
% lam = fmins('fitfun',lam)

pause	% Strike any key to start fitting.

lam = fmins('fitfun',lam,.1)
%	And the above are the nonlinear parameters.

pause	% Strike any key to end.
