echo off
%	-------	Numerical Analysis Toolbox Demonstrations -------
%
%
%		1)	Ordinary differential equations.
%   		2)	Adaptive quadrature.
%		3)	Zerofinding with fzero.
%		4)	Nonlinear minimization with Nelder-Meade search.
%  
%  		0)	Quit.
%  
echo on
clc
% MATLAB itself handles the linear side of numerical analysis.  A
% collection of M-files we call the Numerical Analysis Toolbox extends
% the capabilities of MATLAB into the nonlinear aspects of numerical
% analysis.  The primary tools in the first release include:
%
%   * Numerical solution of ordinary differential equations using
%     automatic step size Runge-Kutta methods based on the Fehlberg
%     4th and 5th order pair of formulas for high accuracy and 
%     a simple 2nd and 3rd order pair for medium accuracy.
%     (ODE45 and ODE23)
%
%   * Numerical evaluation of integrals using a recursive, adaptive
%     Simpson's rule. (QUAD)
%
%   * Finding a zero of a function of one variable using the "fzero"
%     algorithm of Dekker, Brent and Forsythe, Malcolm and Moler.
%     (FZERO)
%
%   * Finding a minimum of a function of several variables using the
%     Nelder-Meade simplex algorithm for nonlinear optimization.
%     (FMINS)

pause	% Strike any key to continue.
clc
%	All the tools provide for the graphical monitoring of the
%	progress of the algorithm.  For example, the adaptive
%	quadrature can plot the integrand as it is being sampled. 
%	All the tools require the specification of a nonlinear
%	function of one or several variables.  These functions
%	are defined by M-files whose names are passed as text
%	arguments to the tools.  For example, QUAD('foo',a,b)
%	finds the numerical value of the integral of foo(x) over
%	the interval [a,b].

pause	% Strike any key to continue.
echo off
clear
while 1
	clc
	help nademo
	demos= ['odedemo '
		'quaddemo'
		'zerodemo'
		'fitdemo '];
	n = input('Select a demo number: ');
	if ((n <= 0) | (n > 5)) 
		break
	end
	d = demos(n,:);
	eval(d)
end
