% This demo goes through some of MATLAB's graphics abilities.
echo on
clc
%
%	This demo goes through some of the MATLAB graphics
%	capabilities. You don't need to hit any keys during
%	the demo; it runs on its own timer.
%

pause(5)
echo off

t = 0:.3:10;
y = sin(t);
plot(t,y)
title('A simple X-Y plot')
pause(5)

plot(t,y,'+')
title('Now with a + symbol, and with grid lines')
grid
xlabel('I do labels too.')
ylabel('Hello, World.')
pause(5)

plot(t,y,t,2*y,t,3*y,t,4*y)
title('Four different line-types')
pause(5)

t = 0:.5:10;
plot(t,t,'.',t,2*t+3,'+',t,3*t+6,'*',t,4*t+9,'o',t,5*t+12,'x')
title('Five different marker-types')
pause(5)

t = .1:.1:3;
loglog(exp(t),exp(t.*t))
title('I do loglog and semilog plots')
pause(5)

t = 0:.05:pi+.1;
y = sin(5*t);
polar(t,y)
title('And polar plots too')
grid
pause(5)

t=0:.3:30;
subplot(221), plot(t,sin(t)),title('Subplots')
subplot(222), plot(t,t.*sin(t))
subplot(223), plot(t,t.*sin(t).^2)
subplot(224), plot(t,t.^2 .*sin(t).^2)
subplot

t = clock;
[x,y] = meshdom(-2:.2:2, -2:.2:2);
z = x .* exp(-x.^2 - y.^2);

t = etime(clock,t);
if t < 5
	pause(5-t)
end
mesh(z)
title('This is a 3-D plot of  z = x * exp(-x^2 - y^2)')
pause(5)
clc
