echo on
% This demo shows some interesting plots.
axis('square')
clc
%	Let's define a peculiar vector, and then plot a growing cosine wave:

t = 0:(.99*pi/2):500;
x = t.*cos(t);

pause % Strike any key for plot.

plot(x,t,'.'), pause

plot(x,t), pause

clc
%	Now plot the growing cosine versus a growing sine:
y = t.*sin(t);

pause % Strike any key for plot.

plot(x,y), pause

axis('normal')

echo off
%	Make a coarser mesh for student version.
v = version;
if (v(1) =='S') | (v(1) == 's')
   dx = 1/3; else, dx = 1/5;
end
echo on

clc
%	Consider the function
%
%	   z = cos(x)*sin(y)
%
%	in the interval -2 < x < 2,  -2 < y < 2.  To draw a mesh or
%	contour graph of this function, first form matrices x and y
%	containing a grid of values in this range:

dx
[x,y] = meshdom(-2:dx:2,-2:dx:2);

pause	% Press any key to continue.

%	We can evaluate this function at all the points in x and y
%	with:

z = cos(x) .* sin(y);

pause	% Press any key to continue.

clc

%	A mesh plot of this function is:

% mesh(z)

pause	% Press any key for plot.
mesh(z), pause
clc
%	The gradient of z = cos(x)*sin(y) is easy to compute analytically:
%
%	  dz/dx = -sin(x)*sin(y)
%	  dz/dy =  cos(x)*cos(y)

pause	% Press any key to continue.

%	We can evaluate the partials for all points in x and y:

dzx = -sin(x).*sin(y);
dzy =  cos(x).*cos(y);

pause	% Press any key to continue.
clc

%	If the gradient of a function is too complicated to compute
%	analytically, or if we start with data, the gradient can be
%	computed numerically:

[pzx,pzy] = gradient(z,dx,dx);

pause	% Press any key to continue.

%	Overlaying a contour plot of the function and a
%	"quiver" plot of the partials puts directional
%	information on the contour plot:

% contour(z), hold on,
% quiver(dzx,dzy), hold off

pause	% Press any key for plot.

contour(z), hold on, quiver(pzx,pzy), hold off, pause
