	program testls2
c
c  There are two Fortran subroutines that you can call from your
c  programs to read and write the .MAT data files used by MATLAB:
c
c    SAVEMAT.FOR - save a matrix to disk
c    LOADMAT.FOR - load a matrix from disk
c
c  These subroutines are known to work with Microsoft Fortran
c  versions 3.0 and higher.  They are not thought to work with
c  PRO-FORT, RM, or Layhey Fortran compilers.
c
c  This file, TESTLS2.FOR, contains an example Fortran main program that
c  shows how to use subroutine LOADMAT and SAVEMAT to load and save some
c  data in a MAT-file.
c
c  See also:
c    - TESTLS1.FOR, another example main program
c    - The SAVEMAT.FOR and LOADMAT.FOR files
c    - TESTLS.C, SAVEMAT.C, and LOADMAT.C, for C-language programs
c    - LOAD in the reference section of the MATLAB User's Guide, for
c      detailed information on the file format of M-files.
c
c  For this test, create several matrices in the MATLAB workspace and save
c  them to the file FOO.MAT using the MATLAB SAVE command.  Next, exit
c  MATLAB and run this test program.  This program, TESTLS, will read 
c  FOO.MAT and write a file called BAR.MAT with the same matrices.
c  After running this test program invoke MATLAB again, load BAR.MAT using
c  the LOAD command, and verify that the matrices loaded are the same as those
c  originally saved to FOO.MAT.
c 
c	Author: S.N. Bangert 5-31-85
c	Revised 1-8-88 JNL
c
c  Character array used to hold the MATLAB variable names (max name 
c  length is 20)
	character name(20)
c
c  Header data and read/write flag from LOADMAT and SAVEMAT 
	integer  m, n, type, namlen, imagf, rwflg
c
c  Arrays used to hold real and imaginary parts of data (dimensioned to
c  hold the largest expected matrix)
	double precision  rpart(1000), ipart(1000)
c
c  Open files in binary mode:
	open(unit=1,file='foo.mat',status='old',form='binary')
	open(unit=2,file='bar.mat',status='new',form='binary')
c
c  Each call to loadmat reads the next matrix on the file until there
c  are no more matrices to be read or there is an error.
c
10	call loadmat(type,m,n,imagf,namlen,name,rpart,ipart,
     $		1,rwflg)
c
	write(*,*) 'rwflg from loadmat = ',rwflg
c
c  A successful read is indicated by rwflg = 0
c
	if ( rwflg .eq. 0 )  then
c
		write(*,6000)  type,m,n,imagf,namlen,
     $				(name(i),i=1,namlen)
6000		format(/1x,'type = ',i3,4x,'m = ',i3,4x,'n = ',i3,4x,
     $		'imagf =',i2/1x,'namlen = ',i2,4x,'name = ',20a1///)
c
c  Write the matrix to bar.mat
c
		call savemat(type,m,n,imagf,namlen,name,rpart,ipart,
     $				2,rwflg)
c
		if ( rwflg .eq. 0 )  go to 10
c
		write(*,*) 'Write error'
	end if
c
	close(1)
	close(2)
c
	end
