function h = dec2hex(d)
%DEC2HEX Decimal to hexadecimal number conversion.
%	DEC2HEX(D) returns decimal integer D in hexadecimal form.
%	For example, DEC2HEX(2748) returns 'ABC'.
%	See also HEX2DEC and HEX2NUM.

%	Author: L. Shure
%	Copyright (c) 1989 by the MathWorks, Inc.

if d==0
	h = setstr('0'); return
end
n = 1 + fix(log(d)/log(16));
s = cumprod([1 16*ones(1,n-1)]);
g = s;
for i=1:n
	g(i) = fix(d/s(n-i+1));
	d = rem(d, s(n-i+1));
	if g(i) > 9
		h(i) = setstr(g(i) + 'A' - 10);
	else
		h(i) = setstr(g(i) + '0');
	end
end
