function b = erf(x1,x2,flag)
%ERF	Error function.
%	ERF(X) returns the value of the error function for every
%	element of X, accurate to about 1E-5.  The error function
%	is the integral of the normal probability distribution
%	function from 0 to X:
%	   ERF(X) = 2/sqrt(pi) integral(0,X) exp(-t^2)
%
%	ERF(X1,X2) returns the value of the error function integrated
%	between X1 and X2:
%	   ERF(X1,X2) = 2/sqrt(pi) integral(X1,X2) exp(-t^2)
%	Either X1, X2, or both may matrices, in which case the function
%	is evaluated at all the elements.
%
%	ERF(X1,Inf) is the complementary error function.
%	ERF(-Inf,X2) integrates from minus infinity.
%
%	ERF(X,'high') and ERF(X1,X2,'high') return very accurate,
%	but slowly computed, values of the error function.
%
%	See also INVERF.

%	C.R. Denham, 6-9-88, 11-10-88.
%	Modified 1-4-89, LS.
%	Copyright (c) 1988-89 by the MathWorks, Inc.

% Reference:
%	[1] N.L. Johnson and S. Kotz, Continuous Univariate
%	Distributions - 1, John Wiley & Sons, p. 55, eq. (26).

[m,n] = size(x1);
if nargin == 1
 arg1 = zeros(m,n);
 arg2 = x1;
 slow = 0;
elseif nargin == 2 & isstr(x2)
 arg1 = zeros(m,n);
 arg2 = x1;
 slow = 1;
elseif nargin == 2
 arg1 = x1;
 arg2 = x2;
 slow = 0;
elseif nargin == 3 & isstr(flag)
 arg1 = x1;
 arg2 = x2;
 slow = 1;
else
 error('Too many or not enough input arguments.')
end
[m1,n1]=size(arg1);
[mm,nn]=size(arg2);
if m1 ~= mm | n1 ~= nn
	if m1 == 1 & n1 == 1
		arg1 = arg1*ones(mm,nn);
	elseif mm == 1 & nn == 1
		arg2 = arg2*ones(m1,n1);
	else
		error('Matrix dimensions must agree.')
	end
end
scaling = sqrt(2);   % To eliminate Gaussian scaling.
x = [arg1 arg2]*scaling;
[m,n] = size(arg1);

if slow
 rx2 = (real(x).^2)/2;
 b = gamma(0.5,rx2);
else
 twenty = 20 * ones(m,2*n);
	xx = min(abs(x),twenty);
	z = exp(-0.5*(xx.*xx))/sqrt(2.*pi);
	t = 1.0./(1+0.33267.*xx);
	tt = t.*t;
	ttt = tt.*t;
	f = 0.4361836.*t - 0.1201676.*tt + 0.9372980.*ttt;
	b = 1 - 2*f.*z;
end
b = b .* sign(x);
b = b(:,(n+1):2*n)-b(:,1:n);
