function feather(x,y,s)
%FEATHER Feather plot.
%	FEATHER(Z) draws a graph that displays the angle and magnitude
%	of the complex elements of Z as arrows emanating from equally
%	spaced points along a horizontal axis.
%
%	FEATHER(X,Y) is equivalent to FEATHER(X+i*Y).  It displays the
%	feather plot for the angles and magnitudes of the elements of
%	matrices X and Y.
%
%	FEATHER(Z,'S') and FEATHER(X,Y,'S') use line style 'S' where
%	'S' is any legal linetype as described under the PLOT command.
%
%	See also COMPASS, ROSE, and QUIVER.

%	Charles R. Denham, MathWorks 3-20-89
%	Copyright (c) 1989 by the MathWorks, Inc.

xx = [0 1 .8 1 .8]';
yy = [0 0 .08 0 -.08].';
arrow = xx + yy.*sqrt(-1);

if nargin == 2
   if isstr(y)
      s = y;
      y = imag(x); x = real(x);
     else
      s = 'r-';
   end
  elseif nargin == 1
   s = 'r-';
   y = imag(x); x = real(x);
end

x = x(:);
y = y(:);
if length(x) ~= length(y)
   error('X and Y must be same length.');
end
[m,n] = size(x);

z = (x + y.*sqrt(-1)).';
a = arrow * z + ones(5,1)*(1:m);
mx = max(max(abs(a)));
axis([0 mx [-mx mx].*(0.3)]);
plot(real(a), imag(a), s, [1 m], [0 0], s);
axis('normal'), axis;
