function [xf,options] = fmin(funfcn,ax,bx,options,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)
%FMIN	Minimum of a function of one variable.
%	FMIN(F,x1,x2) returns the value of x that minimizes F(x) in
%	the interval x1 < x < x2.  The value of x is accurate to within
%	a relative error of 1e-4.  F is a string containing the name
%	of the function.
%	FMIN(F,x1,x2,OPTIONS) allows a vector of optional parameters to
%	be defined. OPTIONS(1) controls how much display output is given; set 
%	to 1 for a display of results, (default is no display: 0).
%	OPTIONS(2) is a measure of the precision required for the values of
%	X at the solution. OPTIONS(3) is a measure of the precision
%	required of the objective function at the solution.
%	For more information type HELP FOPTIONS.

%  References:
%	[1] "Computer Methods for Mathematical Computations", Forsythe,
%	Malcolm, and Moler, Prentice-Hall, 1976.

%	Copyright (c) 1988 by the MathWorks, Inc.
%	Revised 10-14-88 JNL, 7-9-90 ACWG. 
%	Original coding by Duane Hanselman, University of Maine

% initialization
if nargin<4, options=[]; end
options=foptions(options);
print=options(1);
tol=options(2);
if (round(print) ~= print )
% Old syntax:
	%disp('Warning: using old syntax for fmin.')
	%disp('The new syntax is documented in the Optimization Toolbox guide.')
	if nargin<5, P1=0; else,  nargin = nargin - 1; end
	tol = print; print = P1;
end

evalstr = [funfcn];
if ~any(funfcn<48)
        evalstr=[evalstr, '(x'];
        for i=1:nargin - 4
                evalstr = [evalstr,',P',num2str(i)];
        end
        evalstr = [evalstr, ')'];
end

if (~options(14))
	options(14) = 500; 
end



num = 1;
seps = sqrt(eps);
c = 0.5*(3.0 - sqrt(5.0));
a = ax; b = bx;
v = a + c*(b-a);
w = v; xf = v;
d = 0.0; e = 0.0;
x= xf; fx = eval(evalstr);  
if print, clc, fmin_data = [1 xf fx], end
fv = fx; fw = fx;
xm = 0.5*(a+b);
tol1 = seps*abs(xf) + tol/3.0;   tol2 = 2.0*tol1;

% main loop

options(10) = 0; 
while ( abs(xf-xm) > (tol2 - 0.5*(b-a)) )

        num = num+1; gs = 1;

        % is parabolic fit possible
        if abs(e) > tol1    % yes, so fit parabola
                gs = 0;
                r = (xf-w)*(fx-fv);
                q = (xf-v)*(fx-fw);
                p = (xf-v)*q-(xf-w)*r;
                q = 2.0*(q-r);
                if q > 0.0,  p = -p; end
                q = abs(q);
                r = e;  e = d;

                % is parabola acceptable
                if ( (abs(p)<abs(0.5*q*r)) | (p>q*(a-xf)) | (p<q*(b-xf)) )

                        % yes, parabolic interpolation step
                        d = p/q;
                        x = xf+d;
                        step = '   num        xf        fx       parabolic';
         
                        % f must not be evaluated too close to ax or bx
                        if ((x-a) < tol2) | ((b-x) < tol2)
                                si = sign(xm-xf) + ((xm-xf) == 0);
                                d = tol1*si;
                        end
                else    % not acceptable, must do a golden section step
                        gs=1;
                end
        end
        if gs    % a golden-section step is required

                if xf >= xm, e = a-xf;    else, e = b-xf;  end
                        d = c*e;
                        step = '   num        xf        fx       golden   ';
        end

        % function must not be evaluated too close to xf
        si = sign(d) + (d == 0);
        x = xf + si * max( abs(d), tol1 );
	fu = eval(evalstr);  
        if print, clc, fmin_data = [num x fu], disp(step), end

        % update a, b, v, w, x, xm, tol1, tol2
        if fu <= fx
                if x >= xf, a = xf; else, b = xf; end
                v = w; fv = fw;
                w = xf; fw = fx;
                xf = x; fx = fu;
        else % fu > fx
                if x < xf, a = x; else,b = x; end
                if ( (fu <= fw) | (w == xf) )
                        v = w; fv = fw;
                        w = x; fw = fu;
                elseif ( (fu <= fv) | (v == xf) | (v == w) )
                        v = x; fv = fu;
                end
        end
	xm = 0.5*(a+b);
	tol1 = seps*abs(xf) + tol/3.0; tol2 = 2.0*tol1;
	if num > options(14)
		if options(1)>=0
                                disp('Warning: Maximum number of iterations has been exceeded');
				disp('       - increase options(14) for more iterations.')
				options(10)=num;
				return
		end
	end

end
options(8) = eval(evalstr);
options(10)=num;
