function b = gammai(a,x)
%GAMMAI	Incomplete Gamma function.
%	GAMMAI(A,X) returns the value of the incomplete Gamma function
%	for every element of A, integrated to scalar limit X.

%	C.R. Denham 6-9-88
%	Copyright (c) 1988 by the MathWorks, Inc.

if a == NaN | x == NaN
   b = NaN;
  elseif ~min(size(a)) | ~min(size(x))
   b = [];
  elseif a <= 0 | x < 0
   b = [];
  elseif x == Inf
   b = 1;
  else
   itmax = 100;
   epss = 3.0e-7;   %From "Numerical Recipes".
   epss = eps;      %From Matlab.
   gln = log(gamma(a));
   if x < a+1
      if x <= 0
         if x < 0
            b = [];
           else
            b = 0.;
         end
         return
      end
      ap = a;   % Series expansion method.
      sum = 1/a;
      del = sum;
      for n = 1:itmax
         ap = ap+1;
         del = del*x/ap;
         sum = sum+del;
         if abs(del) < abs(sum)*epss
            break;
        end
      end
      b = sum*exp(-x+a*log(x)-gln);
     else
      gold = 0.;   % Continued-fraction method.
      a0 = 1;
      a1 = x;
      b0 = 0;
      b1 = 1;
      fac = 1;
      for n = 1:itmax
         ana = n-a;
         a0 = (a1+a0*ana)*fac;
         b0 = (b1+b0*ana)*fac;
         anf = n*fac;
         a1 = x*a0+anf*a1;
         b1 = x*b0+anf*b1;
         if anf ~= 0
            fac = 1/a1;
            g = b1*fac;
            if abs(g-gold)/g < epss
               break;
            end
         end
      end
      b = 1-exp(-x+a*log(x)-gln)*g;
   end
end
