function x = hex2num(s)
%HEX2NUM IEEE hexidecimal to double precision number conversion.
%	HEX2NUM(S), where S is a 16 character string containing
%	a hexidecimal number, returns the IEEE double precision
%	floating point number it represents.  Fewer than 16
%	characters are padded on the right with zeros.
%
%	For example, HEX2NUM('400921fb54442d18') returns Pi.
%	             HEX2NUM('bff') returns -1.
%
%	NaNs, infinities and denorms are handled correctly.  See
%	also FORMAT HEX.

%	C.B. Moler 12-18-87
%	Revised 1-5-88
%	Copyright (c) 1987-88 by the MathWorks, Inc.

%	More than 16 characters are truncated.

   d = zeros(1,16);
   d(1:length(s)) = abs(s) - '0';
   d = d + ('0'+10-'a').*(d>10);
   neg = d(1) > 7;
   if neg, d(1) = d(1)-8; end
   e = 16*(16*(d(1)-4) + d(2)) + d(3) + 1;
   f = 0;
   for i = 16:-1:4, f = (f + d(i))/16; end
   if e > 1023
      if f == 0, x = inf; else, x = NaN; end
   elseif e < -1022
      x = f * 2^(-1022);
   else
      x = (1 + f) * 2^e;
   end
   if neg, x = -x; end
