function [no,xo] = hist(y,x)
%HIST	Plot histograms.
%	HIST(Y) plots a histogram with 10 equally spaced bins between
%	the minimum and maximum values in Y, showing the distribution
%	of the elements in vector Y.
%	HIST(Y,N), where N is a scalar, uses N bins.
%	HIST(Y,X), where X is a vector, draws a histogram using the
%	bins specified in X.
%	[N,X] = HIST(...) does not draw a graph, but returns vectors
%	X and N such that BAR(X,N) is the histogram.
%	See also BAR.

%	J.N. Little 2-06-86
%	Revised 10-29-87, 12-29-88 LS
%	Copyright (c) 1985-89 by the MathWorks, Inc.

if nargin == 1
	x = 10;
end
if max(size(x)) == 1
	miny = min(y);
	maxy = max(y);
	binwidth = (maxy - miny) ./ x;
	x = miny + (0:x)*binwidth;
	x(length(x)) = maxy;
else
	binwidth = x(2) - x(1);
	x = [x(1)-binwidth/2, x+binwidth./2];
end
nbin = max(size(x));
n = zeros(1,nbin);
for i=2:nbin
	n(i) = sum(y <= x(i));
end
x = x(1:nbin-1) + binwidth./2;
n = n(2:nbin) - n(1:nbin-1);
if nargout == 0
	bar(x,n);
else
	no = n;
	xo = x;
end
