function y = logspace(d1, d2, n)
%LOGSPACE  Generate logarithmically spaced vector.  LOGSPACE(d1, d2) 
%	generates a vector of 50 points logarithmically equally spaced 
%	between decades 10^d1 and 10^d2.  If d2 is pi, then the points are
%	between 10^d1 and pi.  LOGSPACE(d1, d2, N) generates N points.
%	See also LINSPACE and :.

%	Copyright (c) 1989 by the MathWorks, Inc.

if nargin == 2
	n = 50;
end
if d2 == pi
	d2 = log10(pi);
end
y = (10).^ [d1+(0:n-2)*(d2-d1)/(n-1), d2];
