function x = lscov(A,b,V)
%LSCOV	Least squares solution in the presence of known covariance.
%	X = LSCOV(A,b,V) returns the vector X that minimizes
%	(A*X-b)'*inv(V)*(A*X-b) for the case in which length(b) > length(X).
%	This is the over-determined least squares problem with covariance V.
%	The solution is found without needing to invert V which is a square
%	symmetric matrix with dimensions equal to length(b).
%
%	The classical linear algebra solution to this problem is:
%
%		x = inv(A'*inv(V)*A)*A'*inv(V)*b
%
%	See also: \, QR, NNLS.

%	L. Shure 3-31-89
%	Copyright (c) 1989 by the MathWorks, Inc.

%	Reference:
%		[1] G. Strang, "Introduction to Applied Mathematics", 
%		Wellesley-Cambridge, p. 398, 1986.

[m,n] = size(A);
if m <= n
	error('You may only solve an over-determined problem.');
end
[q,r] = qr(A);
efg = q'*V*q;
ind1 = 1:n;
ind2 = n+1:m;
f = efg(ind1,ind2);
g = efg(ind2,ind2);
cd = q'*b;
c = cd(ind1);
d = cd(ind2);
r = r(ind1,ind1);
x = r\(c-f*(g\d));
