function y = median(x)
%MEDIAN	Median value.  For vectors,  MEDIAN(x)  is the median value
%	of the elements in vector X .  For matrices, MEDIAN(x) is a
%	row vector containing the median value of each column.
[m,n] = size(x);
x = sort(x);
if (m==1)
	if rem(n,2)		% n is odd	
		y = x((n+1)/2);
	else			% n is even
		y = (x(n/2) + x(n/2+1))/2;
	end
else
	if rem(m,2)		% m is odd
		y = x((m+1)/2,:);
	else			% m is even
		y = (x(m/2,:) + x(m/2+1,:))/2;
	end
end
