function Q = null(A) 
% NULL  Null space.  Q = null(A) is an orthonormal basis for the
%       null space of A.  Q'*Q = I,  A*Q = 0, and the number of
%       columns of Q is the nullity of A.  See ORTH.

%	C.B. Moler 1-1-86
%	Revised 4-1-87, 7-10-90 CBM
%	Copyright (c) 1986-1990 by the MathWorks, Inc.

% QR decomposition of the transpose.
[Q,R,E]=qr(A');
% Determine effective nullity
tol = eps*norm(A,'fro');
[m,n] = size(A);
if m > 1
   d = sum(abs(R'));
else
   d = abs(R');
end
nul = find(d <= tol);
% Use columns n of Q'.
if length(nul > 0)
   Q = Q(:,nul);
else
   Q = [];
end
