function r = rank(x,tol)
%RANK	Rank.  K = RANK(X) is the number of singular values  of   X
%	that are larger than MAX(SIZE(X)) * NORM(X) * EPS.
%	K = RANK(X,tol) is the number of singular values of  X that
%	are larger than tol .
s = svd(x);
if (nargin == 1)
	tol = max(size(x)) * s(1) * eps;
end
r = sum(s > tol);
