echo off
% 1. New built-in functions
%
% Here is a list of built-in MATLAB functions that are NOT described in
% the user's guide because they were added after printing:
%
% none
%
% 2. New M-Files
%
% Here are some M-files that are NOT described in the user's guide because
% they were added after printing:
%
% clabel	Contour height labels.
% fplot		Plot function.
% hex2dec	Hexadecimal to decimal conversion.
% dec2hex	Decimal to hexadecimal conversion.
% pascal	Pascal's triangle.
% subspace	Compute subspace.
% polyder	Polynomial derivatives.
% gradient	Numerical gradient (partial derivatives).
% quiver	Angle and magnitude as arrows emanating from grid.
% feather	Angle and magnitude plot as arrows from horizontal axis.
% compass	Angle and magnitude plot as arrows from origin.
% rose		Angle histogram, also known as a Rose plot.
% interp1	1-D interpolation using the FFT method.
% interp2	1-D biharmonic data interpolation.
% interp3	2-D biharmonic data interpolation (gridding).
% interp4	2-D bilinear interpolation (expansion) of a matrix.
% lscov		Least-squares solution with known data covariance.
%
% 3. Unlisted M-files
%
% Here are some M-files that are NOT described in the user's guide because
% they were not significant enough to warrant expostulation:
%
% blanks	Returns a string of n blanks.
% expm1		Matrix exponential using Pade approximation.
% expm2		Matrix exponential using Taylor series.
% expm3		Matrix exponential using eigenvalues.
% membrane	Generate L-shape membrane surface.
% mkpp		Make piece-wise polynomial (Used by SPLINE).
% neldstep	Take a Nelder-Mead step (Used by FMINS).
% ppval		Evaluate piece-wise polynomial (Used by SPLINE).
% quadstp	Take a quadstep (Used by QUAD).
% quad8tp	Take a quadstep (Used by QUAD8).
% resi2		Residue of repeated pole.
% umkpp		Un-make piece-wise polynomial (Used by SPLINE).
% nebroyuf, nechdcmp, neconest, nefdjac, nefn, neinck, nelnsrch
% nemodel, neqrdcmp, neqrsolv, nersolv, nestop - used by FSOLVE
%
% Use HELP on these files, or TYPE them for more information.
%
% 4. Demonstrations
%
% A collection of M-files are provided as demonstrations and can be run by
% typing their names:
%
% File		Synopsis
%
% demo		Demo menu for all demos.
% bench		The MATLAB benchmarks.
% census	Predict 1990 population. Some graphics.
% ctheorem	Convolution theorem.
% fitdemo	Nonlinear function fitting.
% matdemo	Introduction to basic MATLAB commands.
% meshdemo	A prettier 3-d sin(x)/x curve and more.
% movies	Row echelon reduction and eigenvalue "movies".
% nademo	Nonlinear numerical analysis demonstrations.
% odedemo	Simulate an ordinary differential equation.
% plotdemo   	Some of the graphics capabilities.
% quaddemo	Quadrature.
% fourier	A square wave is the sum of odd harmonics.
% wow		Some interesting graphics.
% zerodemo	Find the zero of a function.
%
% Alternatively, a demo menu is obtained by typing DEMO while inside MATLAB.
%
% There are also some M-files that are used exclusively by the demos:
%
% demolist	List of demos for menu.
% eigmovie	Eigenvalue movie.
% fitfun	Fit error (Used by FITDEMO).
% humps		Humpy function (Used by QUADDEMO and ZERODEMO).
% ratmovie	Rational reduced row echelon form movie.
% rrefmovi	Reduced row echelon form movie.
% vdpol		van der Pol equation (Used by ODEDEMO).
%
% NOTE: roots1 has been removed because the algorithm was not robust.
%
clc
disp('MATLAB Toolbox Version 3.5')
disp('Press any key to see readme file'),pause
clc, help readme
