function [z,p,k] = cheb2ap(n, rs)
%CHEB2AP Chebyshev type II analog lowpass filter prototype.
%	[Z,P,K] = CHEB2AP(N,Rs) returns the zeros, poles, and gain
%	of an N-th order normalized prototype type II Chebyshev analog
%	lowpass filter with Rs decibels of ripple in the stopband.
%	Type II Chebyshev filters are maximally flat in the passband.
%
%	See also CHEBY2, CHEB2ORD, BUTTAP, and CHEB1AP.

%	L. Shure 1-13-88
%	Copyright (c) 1988-91 by the MathWorks, Inc.

j = sqrt(-1);
delta = 1/sqrt(10^(.1*rs)-1);
mu = asinh(1/delta)/n;
if (rem(n,2))
	m = n - 1;
	z = j ./ cos([1:2:n-2 n+2:2:2*n-1]*pi/(2*n))';
else
	m = n;
	z = j ./ cos((1:2:2*n-1)*pi/(2*n))';
end
% Organize zeros in complex pairs:
i = [1:m/2; m:-1:m/2+1];
z = z(i(:));

p = exp(j*(pi*(1:2:2*n-1)/(2*n) + pi/2)).';
p = sinh(mu)*real(p) + j*cosh(mu)*imag(p);
p = 1 ./ p;
k = real(prod(-p)/prod(-z));

