function v = vratio(u)
%VRATIO	Utility function for use with ELLIP.
%	VRATIO is a function used to calculate the poles of an
%	elliptic filter.  It finds a u so sn(u)/cn(u) = 1/epsilon,
%	with parameter mp.

% eps(2:3) is used for passing in global information - 1/epsilon, the value s/c should
% attain with parameter mp.
mp = eps(3);
ineps = eps(2);
[s,c] = ellipj(u,mp);
v = abs(ineps - s/c);

