function pcf2(f,r,d,tt,mc)
%pcf2(f,r,d,tt,mc)
%kreli k(t) dla zadanej Re{H(jw)}
%f - wektor czstotliwoci w [Hz],
%r - wektor Re{H(jw)} dla czst. z f,
%sprawdz:length(f)-length(r)=0?
%d - liczba podziaw osi czasu i czstotl., tt - maks. czas dla k(t) w ms
%mc - metody cakowania:'p' - prostoktw,'t'- trapezw,'s'- Simpsona
cla;
fmax=max(f);df=fmax/d;tp=tt*.001;dt=tp/d;
%tworzenie nowej siatki czstotliwosci
fp=0:df:fmax;n=1:d;
%obliczanie r(fp) metoda funkcji sklejanych
rp = spline(f,r,fp);
%krelenie aproksymowanej krzywej r(f), x - dane z pomiarow
figure(1);
plot(fp,rp,'w-',f,r,'r+'),grid;
xlabel('f  [Hz]');ylabel('r(f)');hold;
dfi=2*pi*df*dt;
ci=4*df*dt;
%modyfikacja wspoczynnikw r(n*dt)ze wzgldu na wybran metod cakowania
if mc=='t'|mc=='s' rp(1)=rp(1)/2;rp(d+1)=rp(d+1)/2;end
if mc=='s' ci=ci*2/3;for i=2:2:d-1 rp(i)=2*rp(i);end;end
%obliczanie wartoci k(t) 
k(1)=0;
for i=1:d
	fii=dfi*i*n;
	vsi=[1 sin(fii)./fii];
	k(i+1)=rp*vsi'*ci*i;
end
%tworzenie dyskretnej siatki czasu i kreslenie k(t)
t=0:tt/d:tt;
figure(2);
plot(t,k,'w');grid;xlabel('czas w msek');
ylabel('k(t)');title('Odpowiedz jednostkowa');
disp('lim k(t) = ');disp(k(d));
